<?php
class Ultraviolet{
	
	var $rootPath = "";
	
	function Ultraviolet(){
		$this->rootPath = str_replace('\\', '/',str_replace('libs', '', dirname(__FILE__)));
		$this->checkConfig();
		$this->getConfig();
	}	
	
	function &getInstance(){
		static $instance;
        
		if (!is_object($instance))
			$instance = new Ultraviolet();
        
		return $instance;
	}
	
	function checkConfig(){
        if (!file_exists($this->rootPath.'/configuration/configuration.php')){
		   die("Error, configuration file don't exists or empty");
        }
    }
	
	function getConfig(){
		$code = '';
		$f = fopen($this->rootPath.'/configuration/configuration.php', 'rb');
		if($f){
			while($f AND !feof($f)){
				$line = fgets($f, 256);
				$alterLine = str_replace('$', '$this->', $line);
				if($line != $alterLine)
					$code .= $alterLine;
			}
		}
		else
			die("Error, configuration file don't exists or empty");
		fclose($f);
		eval($code);
	}
	
	function get($property){
        $config =& Ultraviolet::getInstance();
        if (isset($config->$property)) 
			return $config->$property;
		else{
        	trigger_error("Invalid property ($property) requested from me");
        	return null;
		}
    }
	
	function parseUrl(){
		$url = "http://".$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME']."?".$_SERVER['QUERY_STRING'];
		$php_query_string = parse_url($url, PHP_URL_QUERY);
		parse_str($php_query_string, $php_request_uri);
		
		return $php_request_uri;
	}
	
	function getScriptPath($scriptname){
		$url = "http://".$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'];
		$url = str_replace($scriptname, "", $url);
		
		return $url;
	}
	
	function getUserAgent(){
		require_once('libs/Browser.php');
		$browser = new Browser();
		
		return $browser->Name.$browser->Version;
	}
	
	function capitalize($string, $e ='utf-8') {
        if (function_exists('mb_strtoupper') && function_exists('mb_substr') && !empty($string)) {
            $string = mb_strtolower($string, $e);
            $upper = mb_strtoupper($string, $e);
            preg_match('#(.)#us', $upper, $matches);
            $string = $matches[1] . mb_substr($string, 1, mb_strlen($string, $e), $e);
        } else {
            $string = ucfirst($string);
        }
        return $string;
    } 
}
?>